<?php $attributes ??= new \Illuminate\View\ComponentAttributeBag;

$__newAttributes = [];
$__propNames = \Illuminate\View\ComponentAttributeBag::extractPropNames((['titulo' => null]));

foreach ($attributes->all() as $__key => $__value) {
    if (in_array($__key, $__propNames)) {
        $$__key = $$__key ?? $__value;
    } else {
        $__newAttributes[$__key] = $__value;
    }
}

$attributes = new \Illuminate\View\ComponentAttributeBag($__newAttributes);

unset($__propNames);
unset($__newAttributes);

foreach (array_filter((['titulo' => null]), 'is_string', ARRAY_FILTER_USE_KEY) as $__key => $__value) {
    $$__key = $$__key ?? $__value;
}

$__defined_vars = get_defined_vars();

foreach ($attributes->all() as $__key => $__value) {
    if (array_key_exists($__key, $__defined_vars)) unset($$__key);
}

unset($__defined_vars); ?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo e($titulo ?? 'Club Deportivo Kardiafit'); ?></title>
    <link rel="icon" href="<?php echo e(asset('favicon.ico')); ?>" type="image/x-icon" />

    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css','resources/js/app.js']); ?>
    <?php echo $__env->yieldPushContent('styles'); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>


    <link href="<?php echo e(asset('fontawesome/css/fontawesome.css')); ?>" rel="stylesheet">
    <link href="<?php echo e(asset('fontawesome/css/solid.css')); ?>" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <script src="https://cdn.jsdelivr.net/npm/html2canvas@1.4.1/dist/html2canvas.min.js"></script>
</head>
<body class="flex flex-col min-h-screen bg-gradient-to-br from-rose-100 via-orange-50 to-amber-100 font-sans text-gray-800">

   <header class="bg-gradient-to-r from-red-700 via-gray-800 to-black text-white shadow-xl py-6 relative overflow-hidden">
    <div class="absolute inset-0 bg-[radial-gradient(circle_at_top_left,_var(--tw-gradient-stops))] from-red-800 via-transparent to-transparent opacity-30 z-0"></div>

    <div class="relative z-10 container mx-auto px-4 flex flex-col md:flex-row justify-between items-center">
        <!-- Logo -->
        <div class="mb-4 md:mb-0 flex items-center gap-4">
            <a href="/">
            <img src="<?php echo e(asset('img/kardiafit.png')); ?>" alt="Logo Kardiafit" class="h-20 w-auto">
            </a>
            <h1 class="text-3xl md:text-4xl font-extrabold tracking-wider uppercase text-white drop-shadow-md">
                Club Deportivo Kardiafit
            </h1>
        </div>

        <!-- Usuario / Auth -->
        <div class="text-right">
            <?php if(Auth()->check()): ?>
                <p class="text-sm font-semibold mb-1">Bienvenido, <?php echo e(Auth()->user()->name); ?></p>
                <?php
$__split = function ($name, $params = []) {
    return [$name, $params];
};
[$__name, $__params] = $__split('users.auth.logout');

$__html = app('livewire')->mount($__name, $__params, 'lw-3552090130-0', $__slots ?? [], get_defined_vars());

echo $__html;

unset($__html);
unset($__name);
unset($__params);
unset($__split);
if (isset($__slots)) unset($__slots);
?>
            <?php else: ?>
                <span class="italic text-sm">Regístrate o inicia sesión</span>
            <?php endif; ?>
        </div>
    </div>

    <!-- Frase motivadora -->
    <div class="relative z-10 text-center mt-4 text-amber-300 font-semibold italic text-lg md:text-xl animate-pulse">
        “La constancia vence al talento. ¡Entrena con corazón, entrena con Kardiafit!”
    </div>
</header>


    <!-- Loader Fitness -->
    <div id="loader" class="fixed inset-0 z-50 flex flex-col items-center justify-center bg-black/90 text-white">
        <!-- Ícono de pesa animado -->
        <div class="mb-6 flex items-center gap-2 animate-bounce">
            <div class="w-2 h-10 bg-gray-400 rounded"></div>
            <div class="w-4 h-28 bg-pink-500 rounded-full"></div>
            <div class="w-6 h-40 bg-pink-500 rounded-full"></div>
            <div class="w-20 h-6 bg-gray-300 rounded"></div>
            <div class="w-6 h-40 bg-pink-500 rounded-full"></div>
            <div class="w-4 h-28 bg-pink-500 rounded-full"></div>
            <div class="w-2 h-10 bg-gray-400 rounded"></div>
        </div>

        <p class="text-xl font-semibold mb-4 animate-pulse">Cargando energía muscular...</p>

        <!-- Barra de progreso animada -->
        <div class="w-64 h-3 bg-gray-700 rounded-full overflow-hidden shadow-lg">
            <div class="h-full bg-gradient-to-r from-rose-400 via-orange-400 to-amber-300 animate-slide-progress rounded-full"></div>
        </div>
    </div>


    <!-- Main content -->
    <main class="flex-1 container mx-auto px-4 py-6">
        <div id="contenido" class="hidden animate-fade-in">
            <?php echo e($slot); ?>

        </div>
    </main>

    <!-- Footer -->
    <footer class="bg-gradient-to-r from-black to-gray-500 text-white text-center py-3">
        <p class="text-sm">&copy; <?php echo e(date('Y')); ?> Mi Página Fitness. Todos los derechos reservados.</p>
    </footer>

    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>

    <?php echo $__env->yieldPushContent('script'); ?>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            const loader = document.getElementById('loader');
            const contenido = document.getElementById('contenido');

            const mostrarContenido = () => {
                // Esperar al menos 1 segundo antes de mostrar
                setTimeout(() => {
                    loader.style.display = 'none';
                    contenido.classList.remove('hidden');
                }, 100);
            };

            if (window.livewire) {
                window.livewire.hook('message.processed', mostrarContenido);
            } else {
                window.addEventListener('load', mostrarContenido);
            }
        });
    </script>

    <style>
        @keyframes slide-progress {
            0% { transform: translateX(-100%); }
            100% { transform: translateX(100%); }
        }
        .animate-slide-progress {
            animation: slide-progress 1.5s infinite linear;
        }
        @keyframes fade-in {
            from { opacity: 0; transform: scale(0.5); }
            to { opacity: 1; transform: scale(1); }
        }
        .animate-fade-in {
            animation: fade-in 1s ease-out;
        }
    </style>
</body>
</html>
<?php /**PATH C:\laravel\k2025\resources\views/components/template.blade.php ENDPATH**/ ?>