<div class="max-w-3xl mx-auto p-6 bg-gradient-to-br from-white to-blue-50 rounded-2xl shadow-xl border border-blue-100">
  <!-- Título principal -->
  <h1 class="text-3xl font-extrabold text-center text-blue-900 mb-2 animate-fade-in-down">🏋️‍♀️ ¡Inscríbete en nuestro nuevo taller!</h1>
  <h2 class="text-xl font-semibold text-center text-blue-700 mb-6 italic">"Integrando el Fitness a Mi Vida"</h2>

  <!-- Descripción -->
  <p class="mb-4 text-gray-800 leading-relaxed">
    ¡Vuelven los entrenamientos! Gracias al financiamiento recibido desde el fondo comunidad del Gobierno, el <strong>Club Deportivo Kardiafit</strong> da continuidad al proyecto anterior con un nuevo taller de fitness <span class="bg-yellow-100 px-1 rounded">completamente gratuito</span>, diseñado para ayudarte a incorporar la actividad física de forma permanente y saludable en tu vida diaria.
  </p>
  <p class="mb-4 text-gray-800 leading-relaxed">
    Tras haber implementado exitosamente la primera etapa, ahora damos un paso más: contamos con <span class="text-blue-700 font-semibold">nueva implementación, más herramientas</span> y un programa renovado que te permitirá mejorar tu condición física, fortalecer tu salud y compartir junto a una comunidad activa y motivada.
  </p>

  <!-- Detalles -->
  <div class="bg-white rounded-lg p-4 shadow-inner border border-gray-200 mb-6">
    <ul class="space-y-2 text-gray-700 text-sm sm:text-base">
      <li><strong>📍 Lugar:</strong> Sede ubicada en Llanos de Tenglo, Pelícano Pardo #3000.</li>
      <li><strong>📅 Inicio:</strong> Lunes 16 de junio de 2025.</li>
      <li><strong>📅 Término:</strong> Miércoles 12 de noviembre de 2025.</li>
      <li><strong>📆 Días:</strong> Lunes, Miércoles y Viernes.</li>
      <li><strong>🧮 Clases:</strong> 60 sesiones en total.</li>
      <li><strong>🎯 Dirigido a:</strong> Personas mayores de 18 años con ganas de moverse y mejorar su calidad de vida. ¡No necesitas experiencia previa!</li>
    </ul>
  </div>

  <!-- Reglamento básico en acordeón -->
  <div class="space-y-4" x-data="{ openItem: null }">
    <h3 class="text-xl font-bold text-blue-800 mb-2">📜 Reglamento del Taller</h3>

    <template x-for="(item, index) in [
      { title: '1. Puntualidad y asistencia', content: 'Se solicita a todos los participantes llegar con al menos 10 minutos de anticipación. La asistencia constante es clave para el buen desarrollo del taller.' },
      { title: '2. Indumentaria adecuada', content: 'Se debe asistir con ropa cómoda para hacer ejercicio, zapatillas deportivas y botella con agua.' },
      { title: '3. Comportamiento y respeto', content: 'El respeto entre participantes y hacia los instructores es fundamental. No se tolerarán conductas agresivas o irrespetuosas.' },
      { title: '4. Justificación de inasistencias', content: 'En caso de no poder asistir, se solicita justificar la inasistencia con anticipación ingresando a esta plataforma y anular.' }
    ]" :key="index">
      <div class="border border-blue-100 rounded-lg bg-white shadow-sm">
        <button 
          @click="openItem === index ? openItem = null : openItem = index" 
          class="w-full flex justify-between items-center px-4 py-3 font-medium text-blue-800 hover:bg-blue-100 transition duration-200"
        >
          <span x-text="item.title"></span>
          <svg :class="{ 'rotate-180': openItem === index }" class="w-5 h-5 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7" />
          </svg>
        </button>
        <div x-show="openItem === index" x-collapse class="px-4 py-2 text-gray-700 text-sm leading-relaxed">
          <p x-text="item.content"></p>
        </div>
      </div>
    </template>
  </div>
</div>

<!-- Alpine.js para funcionalidad del acordeón -->
<script src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js" defer></script>
<?php /**PATH C:\laravel\k2025\resources\views/frontend/invitacion.blade.php ENDPATH**/ ?>