<div class="p-4 border border-gray-200 rounded-2xl shadow-md w-72 mx-auto bg-white space-y-4 text-sm h-80">

    <!-- Fecha centrada -->
    <div class="text-xl font-bold text-gray-700 border-b pb-1 text-center"><?php echo e(\Illuminate\Support\Carbon::parse($fecha)->locale('es')->translatedFormat('l d-m-Y')); ?></div>

    <!--[if BLOCK]><![endif]--><?php if($inscritoHorarioId): ?>
        <?php
            $horario = $horarios->firstWhere('id', $inscritoHorarioId);
        ?>

        <!-- Taller inscrito -->
        <div class="bg-green-50 text-green-800 p-3 rounded-xl space-y-1 shadow">
            <div>
                <!--[if BLOCK]><![endif]--><?php if($persona->asistenciaPorHorario($horario->id)->asistencia): ?>
                    <div class="border border-green-600 bg-green-600 text-white text-center">Asistida <i class="fa-regular fa-circle-check "></i></div>     
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                 <?php if($persona->asistenciaPorHorario($horario->id)->asistencia === 0): ?>
                    <div class="border border-red-600 bg-red-600 text-white text-center">No Asistida <i class="fa-regular fa-circle-xmark"></i></div>     
                <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                
            </div>
            <div class="font-semibold text-base flex items-center justify-center gap-2">
                ✅ <?php echo e($horario?->taller?->nombre); ?> 

            </div>
            <div class="flex items-center justify-center gap-1 text-green-600 text-xs">
                
                <div class="text-xl font-bold"><i class="fa-regular fa-clock pr-4 text-lg "></i><?php echo e($horario?->taller?->inicio->format('H:i')); ?></div>
                
            </div>
            <div class="text-xs text-gray-500 mt-1 text-center">
                <span class="font-medium">Cupos:</span> <?php echo e($horario?->taller?->cuposDisponibles($fecha)); ?>

            </div>
        </div>

        <!-- Otros talleres disponibles -->
        <?php
            $otros = $talleres->where('id', '!=', $horario?->taller?->id);
        ?>

        <!--[if BLOCK]><![endif]--><?php if($otros->count()): ?>
            <div class="bg-gray-50 rounded-xl p-2 shadow-inner">
                <div class="text-xs text-gray-500 font-semibold mb-2 text-center">Otros talleres disponibles</div>
                <div class="space-y-2">
                    <!--[if BLOCK]><![endif]--><?php $__currentLoopData = $otros; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tallerdisponible): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="flex justify-between items-center px-2 py-1 bg-white rounded-md hover:bg-gray-100 text-gray-700 text-xs">
                            <div>
                                <div class="font-medium"><?php echo e($tallerdisponible->nombre); ?></div>
                                <div class="flex items-center gap-1 text-gray-500 text-[11px]">
                                    <i class="fa-regular fa-clock"></i>
                                    <?php echo e($tallerdisponible->inicio->format('H:i')); ?> &bull;
                                    Cupos: <?php echo e($tallerdisponible->cuposDisponibles($fecha)); ?>

                                </div>
                            </div>                            
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?><!--[if ENDBLOCK]><![endif]-->
                </div>
            </div>
        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

        <!-- Botón eliminar -->
        <div class="text-center">
            <button 
                wire:click="eliminar"
                class="mt-3 text-red-500 hover:text-red-700 text-xs font-semibold"
                title="Eliminar inscripción"
            >
                ❌ Anular Reserva
            </button>
        </div>
    <?php else: ?>
        <!-- Lista de talleres -->
        <div class="space-y-2">
            <!--[if BLOCK]><![endif]--><?php $__empty_1 = true; $__currentLoopData = $talleres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $taller): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="flex justify-between items-center px-3 py-2 bg-gray-50 rounded-lg hover:bg-gray-100 shadow-sm">
                    <div class="text-left">
                        <div class="text-gray-800 font-medium"><?php echo e($taller->nombre); ?></div>
                        <div class="text-xs text-gray-500 flex items-center gap-1">
                            <i class="fa-regular fa-clock"></i>
                            <?php echo e($taller->inicio->format('H:i')); ?>

                            &bull;
                            <span>Cupos: <?php echo e($taller->cuposDisponibles($fecha)); ?></span>
                        </div>
                    </div>
                    <!--[if BLOCK]><![endif]--><?php if($taller->cuposDisponibles($fecha)>0): ?>
                        <input 
                        type="checkbox" 
                        wire:click="grabar(<?php echo e($taller->id); ?>)"
                        class="text-blue-600 focus:ring focus:ring-blue-300"
                        />
                    <?php else: ?>
                        <i class="fa-solid fa-user-xmark text-red-600"></i>
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="text-gray-400 text-sm text-center">Sin talleres disponibles</div>
            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
        </div>
    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

</div>
<?php /**PATH C:\laravel\k2025\resources\views/livewire/reservas/reservar.blade.php ENDPATH**/ ?>