<?php

use Illuminate\Support\Facades\Route;
use Livewire\Volt\Volt;

Route::get('/', function () {
    return view('frontend.main');
})->name('main');


Route::get('perfil/{code}', function ($code) {
    return view('frontend.persona.detalle',compact('code'));
})->name('perfil');


Route::get('registroexitoso/{code}', function ($code) {
    return view('frontend.persona.registroexitoso',compact('code'));
})->name('persona.registroexitoso');

Route::get('test', function () {
    return view('frontend.test');
})->name('test');


Route::middleware(['custom.auth'])->group(function () {

    Route::get('admin', function () {
        return view('frontend.admin.index');
    })->name('admin.index');

    Route::get('admin/inscripciones', function () {
        return view('frontend.admin.inscripciones');
    })->name('admin.inscripciones');

    Route::get('admin/listas', function () {
        return view('frontend.admin.listas');
    })->name('admin.listas');


    Route::get('admin/marcarasistencia', function () {
        return view('frontend.admin.marcarasistencia');
    })->name('admin.marcarasistencia');

    Route::get('admin/marcarasistencia/{fecha}/taller/{tallerId}', function ($fecha,$tallerId) {
        return view('frontend.admin.marcarasistenciafecha',compact('fecha','tallerId'));
    })->name('admin.marcarasistenciafecha');

    Route::get('admin/logs', function () {
        return view('frontend.admin.logs');
    })->name('admin.logs');

    Route::get('admin/cumpleanos', function () {
        return view('frontend.admin.cumpleanos');
    })->name('admin.cumpleanos');


    Route::get('admin/reservar/{fecha}', function ($fecha) {
        return view('frontend.admin.reservar',compact('fecha'));
    })->name('admin.reservar');

});

Route::get('admin/hojaasistencia/{fecha}/taller/{tallerId}', function ($fecha,$tallerId) {
    return view('frontend.admin.hojaasistencia',compact('fecha','tallerId'));
})->name('admin.hojaasistencia');

Route::get('info/registro', function () {
    return view('frontend.informacion.registro');
})->name('informacion.registro');

Route::view('dashboard', 'dashboard')
    ->middleware(['auth', 'verified'])
    ->name('dashboard');

Route::middleware(['auth'])->group(function () {
    Route::redirect('settings', 'settings/profile');

    Volt::route('settings/profile', 'settings.profile')->name('settings.profile');
    Volt::route('settings/password', 'settings.password')->name('settings.password');
    Volt::route('settings/appearance', 'settings.appearance')->name('settings.appearance');
});

require __DIR__.'/auth.php';
