

<div class="px-2 w-max">
    <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 xl:grid-cols-4 gap-4">

        <div>
            <div class="border-max p-4 rounded bg-white rounded-xl shadow">
                    <p><span class="font-semibold">Movil:</span> {{$persona->nombrecompleto()}} </p>
                    <p><span class="font-semibold">Movil:</span> {{$persona->movil}}</p>
                    <p><span class="font-semibold">RUT:</span> {{ $persona->ci() }}</p>
                    <p><span class="font-semibold">Email:</span> {{ $persona->email }}</p>
                    <p><span class="font-semibold">Nacimiento:</span> {{ $persona->nacimiento->format('d-m-Y') }}</p>
                    <p><span class="font-semibold">Edad:</span> {{ $persona->edad() }}</p>
                    <p><span class="font-semibold">Inscripción:</span> {{ $persona->creacion }}</p>
                    <p><span class="font-semibold">Reservas:</span> {{ $persona->horarios->count() }} clases</p>
                    </div>
        </div>
        @forelse ($talleresFechas as $fecha)

        @if (Carbon\Carbon::now()->format('dmY') <= $fecha->format('dmY'))
            @livewire('reservas.reservar', [$persona->id, $fecha],key('reservas'.now()))
        @else
        <div class="bg-white shadow border text-center font-bold rounded-xl">
            <div>{{$fecha->format('d-m-Y')}}</div>
            <div class="text-green-600"> Actividad finalizada <i class="fa-regular fa-square-check "></i></div>
        </div>
            
            
        @endif
            


        @empty
            <div class="col-span-full text-center text-gray-400">
                No hay fechas disponibles.
            </div>
        @endforelse
    </div>
</div>

