<div class="space-y-8">

    {{$personas->sortBy('nacimiento')->first()->nombrecompleto()}} - {{$personas->sortBy('nacimiento')->first()->edad()}}
    @for($mes = 1; $mes <= 12; $mes++)
        @php
            $personasMes = $personas
                ->filter(fn($p) => \Carbon\Carbon::parse($p->nacimiento)->month === $mes)
                ->sortBy(fn($p) => \Carbon\Carbon::parse($p->nacimiento)->day);

            $nombreMes = \Carbon\Carbon::create()->month($mes)->locale('es')->monthName;
        @endphp

        <div class="bg-white rounded shadow p-4">
            <h2 class="text-lg font-semibold capitalize text-gray-700 border-b pb-3 mb-4">
                {{ $nombreMes }}
            </h2>

            @if($personasMes->isNotEmpty())
                <div class="overflow-x-auto">
                    <table class="w-full text-sm text-left text-gray-700">
                        <thead class="bg-gray-100 text-gray-600 uppercase tracking-wide">
                            <tr>
                                <th class="px-4 py-2">Nombre</th>
                                <th class="px-4 py-2">Edad</th>
                                <th class="px-4 py-2">Fecha de nacimiento</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($personasMes as $persona)
                                <tr class="border-b">
                                    <td class="px-4 py-2 whitespace-nowrap">
                                       {{ \Carbon\Carbon::parse($persona->nacimiento)->format('d') }} - {{ $persona->nombrecompleto() }}
                                    </td>
                                    <td class="px-4 py-2">
                                        {{ $persona->edad() }}
                                    </td>
                                    <td class="px-4 py-2">
                                        {{ \Carbon\Carbon::parse($persona->nacimiento)->format('d-m-Y') }}
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            @else
                <div class="text-sm text-gray-500 italic">Sin cumpleaños registrados este mes.</div>
            @endif
        </div>
    @endfor
</div>
