<div class="p-4 space-y-4">
    @forelse ($personas as $persona)
        <div class="border border-gray-300 rounded-lg shadow-sm p-4 bg-white">
            <h2 class="text-lg font-semibold text-gray-800 mb-2">{{ $persona->nombrecompleto() }}</h2>
            
            @forelse ($persona->horarios as $horario)
                <div class="flex justify-between items-center bg-gray-50 rounded-md p-2 mb-1">
                    <span class="text-gray-700 font-medium">
                        {{ $horario->fecha->format('d-m-Y') }}
                    </span>
                    <div>
                        {{$horario->taller->nombre}}
                        <span class="text-blue-600 font-semibold">
                        {{ $horario->taller->inicio->format('H:i') }}
                         </span>
                    </div>
                    
                </div>
            @empty
                <p class="text-sm text-gray-500 italic">Sin horarios registrados</p>
            @endforelse
        </div>
    @empty
        <p class="text-center text-gray-500">No hay personas registradas.</p>
    @endforelse
</div>
