<div class="w-full overflow-x-auto">
    @forelse ($fechas as $fecha)
        <h3 class="text-sm font-semibold text-gray-700 mt-4 mb-2 bg-green-200">
            📅 {{ $fecha->format('d-m-Y') }}
        </h3>

        <table class="w-full border border-gray-300 text-sm rounded-lg shadow-sm">
            <thead class="bg-gray-100">
                <tr>
                    <th class="px-3 py-2 text-left border-b">Taller</th>
                    <th class="px-3 py-2 text-center border-b">Asistencia</th>
                    <th class="px-3 py-2 text-left border-b">Persona</th>
                    
                </tr>
            </thead>
            <tbody>
                @forelse ($horarios->where('fecha',$fecha) as $horario)
                    @foreach ($horario->personas->sortBy('nombres') as $persona)
                        <tr class="hover:bg-gray-50 {{$persona->pivot->asistencia == 1 ? 'bg-green-200' : ''}}">
                            <td class="px-3 py-2 border-b">{{ $horario->taller->nombre }}</td>
                            <td class="px-3 py-2 text-center border-b">                                
                                @if ($persona->pivot->asistencia == 1)
                                    <x-button class="w-10 mx-2" wire:click="marcar({{ $horario->id }}, {{ $persona->id }}, 0)">
                                        <span class="text-red-600 font-semibold">✘</span>
                                    </x-button>
                                @elseif($persona->pivot->asistencia == 0)
                                    <x-button class="w-10 mx-2" wire:click="marcar({{ $horario->id }}, {{ $persona->id }}, 1)">
                                        <span class="text-green-600 font-semibold">✔</span>
                                    </x-button>
                                @endif
                            </td>
                            <td class="px-3 py-2 border-b">{{ $persona->nombrecompleto() }}</td>
                            
                        </tr>
                    @endforeach
                @empty
                    <tr>
                        <td colspan="3" class="px-3 py-2 text-center text-gray-500">No hay horarios</td>
                    </tr>
                @endforelse
            </tbody>
        </table>
    @empty
        <p class="text-gray-500 text-sm">No hay registros disponibles</p>
    @endforelse
</div>
