<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Casts\Attribute;

class Taller extends Model
{
    protected $table = "talleres";
    protected $fillable =[
        'id',
        'nombre',
        'inicio',       
        'fin',
        'fechainicio',
        'fechatermino',
        'maps',
        'direccion',
        'cupos',        
    ];

    public function cuposDisponibles($fecha)
    {
        $horarios = $this->horarios()->whereDate('fecha',$fecha)->get();
        return $this->cupos - $horarios->sum(fn($horario)=>$horario->personas->count());
    }


    public function nombrecompleto()
    {
        return "{$this->nombre} {$this->inicio->format("H:i")} - {$this->fin->format("H:i")}";
    }
    public function horarios()
    {
        return $this->hasMany(Horario::class);
    }



    public function inicio(): Attribute
    {
        return Attribute::make(
            get: fn ($value) =>Carbon::parse($value),
        );
    }

    public function fin(): Attribute
    {
        return Attribute::make(
            get: fn ($value) =>Carbon::parse($value),
        );
    }

    public function fechainicio(): Attribute
    {
        return Attribute::make(
            get: fn ($value) =>Carbon::parse($value),
        );
    }

    public function fechatermino(): Attribute
    {
        return Attribute::make(
            get: fn ($value) =>Carbon::parse($value),
        );
    }

}
