<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Freshwork\ChileanBundle\Rut;
use Carbon\Carbon;
use Illuminate\Support\Str;
use App\Models\Asistencia;
use Illuminate\Database\Eloquent\Casts\Attribute;


class Persona extends Model
{
    use HasFactory;
    protected $table = "personas";
    protected $fillable =[
        'id',
        'rut',
        'email',       
        'nombres',
        'paterno',
        'materno',
        'estado',
        'dv',
        'movil',
        'nacimiento',
        'creacion',
        'qrcode'
    ];


    public function tieneAsistencia($fecha)
    {
        return Asistencia::where('persona_id',$this->id)->whereDate('fecha',Carbon::parse($fecha))->exists();
    }

    public function haAsistido($fecha)
    {
        $asistencia = Asistencia::where('persona_id', $this->id)
            ->whereDate('fecha', Carbon::parse($fecha))
            ->first();

        return $asistencia?->asistencia === 'Asistido';
    }


    public function asistencia($fecha)
    {
        return Asistencia::where('persona_id',$this->id)->whereDate('fecha',Carbon::parse($fecha))->get()->first();
    }

    public function asistencias()
    {
        return $this->hasMany(Asistencia::class);
    }

    public function reserva($fecha)
    {
        
    }
    public function edad()
    {
        return Carbon::parse($this->nacimiento)->age;
    }

    public function ci()
    {
        return Rut::parse($this->rut . $this->dv)->format(Rut::FORMAT_COMPLETE);
    }

    public function asistenciaPorHorario($horarioId)
    {
        return $this->horarios->firstWhere('id', $horarioId)->pivot;
    }

    public function user()
    {
        return User::where('persona_id',$this->id)->get()->last();
    }


    public function nombrecompleto()
    {
        return  ucwords(strtolower($this->nombres))." ".ucwords(strtolower($this->paterno))." ".ucwords(strtolower($this->materno));
    }


    public function horarios()
    {
        return $this->belongsToMany(Horario::class)
                    ->withPivot('id','fecha','asistencia')
                    ->withTimestamps();
    }

    public function nacimiento(): Attribute
    {
        return Attribute::make(
            get: fn ($value) =>Carbon::parse($value),
        );
    }

}
