<?php

namespace App\Livewire\Users;

use Illuminate\Support\Facades\Hash;
use Livewire\Attributes\On; 
use Illuminate\Support\Str;
use App\Models\Persona;
use App\Models\User;
use Livewire\Component;


class PassCreate extends Component
{
    public $persona;
    public $passw;
    public $user;
public $code;
    
    #[On('actualizar')]
    public function actualizar()
    {
        $this->mount($this->code);
    }
    public function render()
    {
        return view('livewire.users.pass-create');
    }
    public function mount($code)
    {
        $persona = Persona::where('qrcode',$code)->get()->first();
        $this->persona = $persona;
        $this->code = $code;
        $this->user = $persona->user();
    }
    public function grabar()
    {
        $this->user->update(
            [
                'password' => Hash::make($this->passw),
            ]
        );
        return redirect()->route('main');
        $this->dispatch('actualizar');
    }
    public function crearPasswd($longitud = 6)
    {
        $caracteres = '0123456789abcdefghjkmnopqrstuvwxyzABCDEFGHJKLMNOPQRSTUVWXYZ';
        $cadenaAleatoria = Str::random($longitud);
        
        // Si la cadena generada no tiene la longitud deseada, la completamos
        if (strlen($cadenaAleatoria) < $longitud) {
            $faltantes = $longitud - strlen($cadenaAleatoria);
            $cadenaAleatoria .= substr(str_shuffle($caracteres), 0, $faltantes);
        }
        
        $this->passw = $cadenaAleatoria;
        //$this->dispatch('actualizar');
        return $cadenaAleatoria;
    }

    public function crearUsuario()
    {
        $passwd = $this->crearPasswd($longitud = 6);
        $user = User::create([
            'name'=>$this->persona->nombres,
            'email'=>$this->persona->email,
            'persona_id'=>$this->persona->id,
            'password'=>Hash::make($passwd),
        ]);
        //dd($user);
        $this->user = $user;
        $this->dispatch('actualizar');
    }

}
