<?php

namespace App\Livewire\Reservas;

use Livewire\Component;
use App\Models\Persona;
class Resumen extends Component
{
    public $persona;
    public $reservas;
    public $talleres;
    public function render()
    {
        return view('livewire.reservas.resumen');
    }
    public function mount($code)
    {
        $this->persona = Persona::find($code);
        $this->reservas  = $this->persona->horarios;
        $this->talleres  = $this->reservas->map(fn($horario)=>$horario->taller)->unique();
    }
}
