<?php

namespace App\Livewire\Reservas;

use Livewire\Component;
use App\Models\Persona;
use App\Models\Taller;
use App\Models\Horario;
use Carbon\Carbon;

class Reservar extends Component
{
    public $horarios;
    public $talleres;
    public $fecha;
    public $persona;
    public $inscritoHorarioId = null; // ID del horario inscrito (si existe)

    public function mount($persona, $fecha)
    {
        $this->fecha = Carbon::parse($fecha);
        $this->persona = Persona::findOrFail($persona);

        $this->horarios = Horario::whereDate('fecha', $fecha)->get();
        $this->talleres = $this->horarios->map(fn($horario) => $horario->taller)->unique();

        $this->actualizarInscripcion();
    }

    public function actualizarInscripcion()
    {
        $horario = $this->persona->horarios()
            ->wherePivot('fecha', $this->fecha)
            ->first();

        $this->inscritoHorarioId = $horario?->id;
    }

    public function grabar($tallerId)
    {
        // Evita múltiples inscripciones
        if ($this->inscritoHorarioId) return;

        $horario = Horario::where('taller_id', $tallerId)
            ->whereDate('fecha', $this->fecha)
            ->first();

        $cupos = Taller::find($tallerId)->cuposDisponibles($this->fecha);

        if ($horario and $cupos > 0 ) {
            $this->persona->horarios()->attach($horario->id, ['fecha' => $this->fecha]);
            $this->actualizarInscripcion();
        }
    }

    public function eliminar()
    {
        if (!$this->inscritoHorarioId) return;

        $this->persona->horarios()->detach($this->inscritoHorarioId);
        $this->inscritoHorarioId = null;
    }

    public function render()
    {
        return view('livewire.reservas.reservar');
    }
}
