<?php

namespace App\Livewire\Personas;

use Livewire\Component;
//use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\Hash;
use Freshwork\ChileanBundle\Rut;
use Illuminate\Support\Str;
//use App\Models\Departamento;
//use App\Models\Contratista as Empresa;
//use App\Models\Cargo;
use Carbon\Carbon;
use App\Models\Persona;
use App\Models\User;

use App\Mail\RegistroConfirmado;
use Illuminate\Support\Facades\Mail;

use Livewire\Attributes\On; 

class Registro extends Component
{
    public $rut_completo;
    public $rut;
    public $dv;
    public $personaExiste;

    public $nombres = '';
    public $paterno = '';
    public $materno = '';
    public $email = '';
    public $movil = '';
    public $nacimiento = '';
  
    public $mensajeRut;
    public $persona;
    public $passwd;

    public $msgRegistroExitoso;

    public $mensajedelRut;

    protected $rules = [
        'rut_completo'=>'required',
        'email' => 'required|email',
        'nombres' => 'required',
        'paterno' => 'required',
        'materno' => 'required',
        'movil' => 'required|digits:9',
        'nacimiento' => 'required',
    ];

    
    #[On('actualizar')]
    public function actualizar()
    {
        $this->mount($this->msgRegistroExitoso);
    }


    public function validarRut()
    {
        
        // Limpiar y normalizar el RUT: solo números y letra K
        $rutLimpio = preg_replace('/[^0-9kK]/', '', $this->rut_completo);
        $this->rut_completo = $rutLimpio;

        if (strlen($rutLimpio) > 9 and strlen($rutLimpio) <= 8) {
            return false;
        } else {
            
        


        // Verificar longitud mínima (8 dígitos + dígito verificador)
        if (strlen($rutLimpio) < 8) {
            $this->mensajeRut = false;
            return false;
        }

        // Separar cuerpo y dígito verificador
        $body = substr($rutLimpio, 0, -1);
        $dv = strtoupper(substr($rutLimpio, -1));

/*
        // Validar RUT usando la clase Rut
        if (!Rut::set($body, $dv)) {
            $this->mensajeRut = false;
            return false;
        }
*/
        // Formatear y almacenar el RUT validado
        $rutCompletoFormateado = Rut::parse($body . $dv)->format(Rut::FORMAT_COMPLETE);
        $this->mensajeRut = $rutCompletoFormateado;
        $this->rut_completo = $rutCompletoFormateado;

        // Validación final silenciosa
        return Rut::parse($this->rut_completo)->quiet()->isValid()
            ? $this->mensajeRut
            : false;

        }
        
    }


    public function checkRut()
    {
        if($this->validarRut())
        {
            $this->mensajedelRut = "Rut Correcto";
            $this->personaExiste =  $this->personaExistente();
            
        }
        else
        {
            $this->mensajedelRut = "Rut no Válido";
        }
    }
    
    public function personaExistente()
    {
        //$rut = $this->rut_completo;
        
        $rutLimpio = preg_replace('/[^0-9kK]/', '', $this->rut_completo);
        $body = Rut::parse( $rutLimpio)->number();
        $persona = Persona::where('rut', $body)->first();
        
        if($persona)
        {
            $this->persona = $persona;
            return true;
        }
        else
        {
            return false;
        }
        
    }

    public function verificarDatos()
    {
        
        $this->checkRut();
        $this->validate();
        $this->msgRegistroExitoso = null;
        $this->personaExiste = $this->personaExistente();
        $this->validarRut();
        
        
    }

    public function mount($msgRegistroExitoso = null)
    {      
        $this->msgRegistroExitoso = $msgRegistroExitoso;

                    
    }

    public function rellenar()
    {
                    $this->nombres = 'Juan Carlos';
                    $this->paterno = 'Diaz';
                    $this->materno = 'Villegas';
                    $this->email = 'jdi@gmail.com';
                    $this->movil = '966021859';
                    $this->nacimiento = '1977-03-04';
    }


    public function validandoCampos()
    {
        $this->validate();
    }
   
    public function guardar()
    {
        $this->validate();

        $body = Rut::parse($this->rut_completo)->number();
        $vn = Rut::parse($this->rut_completo)->vn();

        if ($this->personaExiste) {
            $persona = Persona::where('rut',$body)->get()->first();
      
        } else {
            $persona = Persona::create(           
            [             
                'rut'=>$body,   
                'dv' =>$vn,
                'nombres' => $this->nombres,
                'paterno' => $this->paterno,
                'materno' => $this->materno,
                'email' => $this->email,
                'movil' => "+569".substr($this->movil,-8),
                'nacimiento' => $this->nacimiento,     
                'creacion'=>Carbon::now(),
                'qrcode'=>Str::random(32),           
            ]
        );

        $this->crearUsuario($persona);
        }
         

       
        $this->reset(['nombres', 'paterno', 'materno', 'email', 'movil', 'nacimiento','rut_completo']);
        $this->rut = $body.'-'.$vn;
        
        session()->flash('message', 'Persona guardada correctamente');

        $this->msgRegistroExitoso = 'Registro Exitoso, tu clave de acceso fue enviada el email '.$persona->email;

        $this->dispatch('actualizar');
    }

    public function render()
    {
        return view('livewire.personas.registro');
    }


    public function crearUsuario(Persona $persona)
    {
       $user =  User::create(
            [
            'rut'=>$persona->rut.$persona->dv,
            'name'=>$persona->nombres,
            'email'=>$persona->email,
            'persona_id'=>$persona->id,
            'password'=>Hash::make($this->passwd),
            ]
        );
        
        Mail::to($persona->email)->send(new RegistroConfirmado($persona));

        $this->user = $user;
        $this->dispatch('actualizar');
    }


    public function testMail()
    {
        $persona = Persona::find(155);  
        //dd($persona);
        Mail::to($persona->email)->send(new RegistroConfirmado($persona));
    }

          

    

}
