<?php

namespace App\Livewire\Horarios;

use Livewire\Component;
use App\Models\Horario;
use App\Models\Taller;
use Carbon\Carbon;
use App\Helpers\Hp;
class Listas extends Component
{
    public $horarios;
    public $talleres;
    public $fechas;
    public function render()
    {
        return view('livewire.horarios.listas');
    }
    public function mount()
    {
        $horarios = Horario::whereMonth('fecha',Carbon::now())->get();
        $this->fechas = $horarios->map(fn($horario)=>$horario->fecha)->unique();
        $this->horarios = $horarios;
        //Hp::saveLog('actualizado');
    }

    public function irA($fecha,$tallerId)
    {
        return redirect()->route('admin.hojaasistencia',$fecha,$tallerId);
    }
}
