<?php

namespace App\Livewire;

use Livewire\Component;
use Illuminate\Support\Facades\Mail;
use App\Mail\RegistroConfirmado;

class Email extends Component
{
    public $persona;
    public function render()
    {
        return view('livewire.email');
    }

    public function mount()
    {
        $this->persona = Auth()->User()->persona;
    }

    public function enviar()
    {
        $destinatario = $this->persona->email;
        Mail::to($destinatario)->send(new RegistroConfirmado($this->persona));
    }
}
