<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use Carbon\Carbon;
use App\Models\Persona;
use App\Models\Horario;
use Livewire\Attributes\On; 
class Reservar extends Component
{
    public $personas;
    public $fecha;
    public $fechas;
    
    #[On('actualizar')]
    public function actualizar()
    {
        $this->mount($this->fecha);
    }
    
    public function render()
    {
        return view('livewire.admin.reservar');
    }
    public function mount($fecha)
    {
        $fecha = Carbon::parse($fecha);
        $this->personas = Horario::whereDate('fecha', $fecha)->orderBy('taller_id')->get()->flatmap(fn($horario)=>$horario->personas)->sortBy('nombres');
        $this->fecha = $fecha;
        $this->fechas = self::crearFechas();
    }
    private function crearFechas()
    {
        $personas = Persona::get()->filter(fn($persona)=>$persona->horarios->isNotEmpty())->sortBy('nombres');
        $horarios = $personas->flatmap(fn($persona)=>$persona->horarios->pluck('fecha'))->unique()->sort();
        return $horarios;       
    }

    public function color(Persona $persona, $fecha)
    {
        $asistencia = $persona->asistencia($fecha);

        if (!$asistencia) {
            return 'text-gray-400'; // Sin asistencia registrada para ese día
        }

        return match($asistencia->asistencia) {
            'Asistido', 1 => 'border-2 border-green-600 text-green-600',
            'Inasistido', 0 => 'border-2 border-red-600 bg-red-200 text-red-600',
            null => 'text-yellow-600',
            default => '',
        };
    }
}
