<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\Taller;
use Carbon\Carbon;
use Livewire\Attributes\On; 

class MarcarAsistencia extends Component
{
    public Taller $taller;
    public $personas;
    public $horario;
    public $fecha;

    #[On('actualizar')]
    public function actualizar()
    {
        $this->mount($this->fecha, $this->taller);
    }

    public function mount($fecha, Taller $taller)
    {
        $this->fecha = $fecha;
        $this->taller = $taller;
        $this->horario = $taller->horarios()->whereDate('fecha', $fecha)->first();

        $this->personas = $this->horario?->personas ?? collect();
    }

    public function render()
    {
        return view('livewire.admin.marcar-asistencia');
    }

    public function asistido($personaId)
    {
        return $this->horario
                    ->personas()
                    ->wherePivot('persona_id', $personaId)
                    ->wherePivot('asistencia', true)
                    ->exists();
    }

    public function confirmarAsistencia($personaId, $asistencia)
    {
        $this->horario->personas()->updateExistingPivot($personaId, [
            'asistencia' => $asistencia,
        ]);
        $this->dispatch('actualizar');
        session()->flash('message', 'Asistencia actualizada correctamente.');
    }

    public function confirmarContinuidad($fecha, $persona)
    {
        Carbon::setLocale('es');
        $fechaCarbon = Carbon::parse($fecha);
        $hora = now()->hour;

        $saludo = $hora < 12 ? 'Buenos días' : ($hora < 20 ? 'Buenas tardes' : 'Buenas noches');
        $fechaFormateada = $fechaCarbon->translatedFormat('l j \d\e F');

        return "{$saludo}, {$persona->nombres}, soy Juan Carlos del Club Deportivo Kardiafit. "
            . "He notado que en nuestro registro figura una inasistencia tuya a la clase del día {$fechaFormateada}. "
            . "¿Deseas continuar participando en las próximas sesiones? Tu confirmación es importante para que podamos asignar los cupos disponibles de forma eficiente. "
            . "Agradezco mucho tu compromiso y quedo atento a tu respuesta.";
    }
}
