<?php

namespace App\Livewire\Admin;

use Livewire\Component;
use App\Models\Persona;
use App\Models\Horario;
use App\Models\Asistencia;
use Livewire\Attributes\On;

class Marcar extends Component
{
    public $asistencia;
    public $horario;
    public $persona;


    #[On('actualizar')]
    public function actualizar()
    {
        $this->mount($this->persona, $this->horario);
    }

    public function render()
    {
        return view('livewire.admin.marcar');
    }

    public function mount(Persona $persona, Horario $horario)
    {
        //$horario = Horario::find( $horarioId);
        $this->persona = $persona;
        $this->horario = $horario;
    }

    public function tieneAsistencia()
    {
        return Asistencia::where('persona_id',$this->persona->id)->where('taller_id',$this->horario->taller_id)->whereDate('fecha',$this->horario->fecha)->get();
    }
    public function grabar($type)
    {
        Asistencia::create([
            'fecha'=>$this->horario->fecha,
            'persona_id'=>$this->persona->id,
            'taller_id'=>$this->horario->taller_id,
            'asistencia'=> $type           
        ]);

      $this->dispatch('actualizar');
    }
}
